/*
 * Decompiled with CFR 0.152.
 */
package net.xolt.freecam.config.gui;

import com.google.common.util.concurrent.AtomicDouble;
import com.mojang.blaze3d.platform.Window;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Supplier;
import me.shedaniel.clothconfig2.gui.entries.TooltipListEntry;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractSliderButton;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.util.Mth;
import net.xolt.freecam.Freecam;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class DoubleSliderEntry
extends TooltipListEntry<Double> {
    private final Slider sliderWidget;
    private final Button resetButton;
    private final AtomicDouble value;
    private final double original;
    private final int precision;
    private final double minimum;
    private final double maximum;
    private final Supplier<Double> defaultValue;
    private final List<AbstractWidget> widgets;

    DoubleSliderEntry(Component fieldName, int precision, double minimum, double maximum, double value, Component resetText, Supplier<Double> defaultValue, @Nullable Consumer<Double> save) {
        super(fieldName, null);
        this.value = new AtomicDouble(value);
        this.original = value;
        this.defaultValue = defaultValue;
        this.maximum = maximum;
        this.minimum = minimum;
        this.precision = precision;
        this.saveCallback = save;
        this.sliderWidget = new Slider(0, 0, 152, 20, (this.value.get() - minimum) / (maximum - minimum));
        this.sliderWidget.updateMessage();
        this.resetButton = Button.builder((Component)resetText, widget -> this.setValue(this.defaultValue.get())).width(Freecam.MC.font.width((FormattedText)resetText) + 6).build();
        this.widgets = List.of(this.sliderWidget, this.resetButton);
    }

    public Double getValue() {
        return this.value.get();
    }

    public void setValue(double value) {
        double clamped = Mth.clamp((double)value, (double)this.minimum, (double)this.maximum);
        this.value.set(clamped);
        this.sliderWidget.setValue((clamped - this.minimum) / (this.maximum - this.minimum));
        this.sliderWidget.updateMessage();
    }

    public boolean isEdited() {
        return super.isEdited() || this.getValue() != this.original;
    }

    public Optional<Double> getDefaultValue() {
        return Optional.ofNullable(this.defaultValue).map(Supplier::get);
    }

    @NotNull
    public List<? extends GuiEventListener> children() {
        return this.widgets;
    }

    public List<? extends NarratableEntry> narratables() {
        return this.widgets;
    }

    public void render(GuiGraphics graphics, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean isHovered, float delta) {
        super.render(graphics, index, y, x, entryWidth, entryHeight, mouseX, mouseY, isHovered, delta);
        Window window = Freecam.MC.getWindow();
        this.resetButton.active = this.isEditable() && this.getDefaultValue().isPresent() && this.defaultValue.get().doubleValue() != this.value.get();
        this.resetButton.setY(y);
        this.sliderWidget.active = this.isEditable();
        this.sliderWidget.setY(y);
        Component name = this.getDisplayedFieldName();
        if (Freecam.MC.font.isBidirectional()) {
            graphics.drawString(Freecam.MC.font, name.getVisualOrderText(), window.getGuiScaledWidth() - x - Freecam.MC.font.width((FormattedText)name), y + 6, this.getPreferredTextColor());
            this.resetButton.setX(x);
            this.sliderWidget.setX(x + this.resetButton.getWidth() + 1);
        } else {
            graphics.drawString(Freecam.MC.font, name.getVisualOrderText(), x, y + 6, this.getPreferredTextColor());
            this.resetButton.setX(x + entryWidth - this.resetButton.getWidth());
            this.sliderWidget.setX(x + entryWidth - 150);
        }
        this.sliderWidget.setWidth(150 - this.resetButton.getWidth() - 2);
        this.resetButton.render(graphics, mouseX, mouseY, delta);
        this.sliderWidget.render(graphics, mouseX, mouseY, delta);
    }

    private final class Slider
    extends AbstractSliderButton {
        private Slider(int x, int y, int width, int height, double value) {
            super(x, y, width, height, (Component)Component.empty(), value);
        }

        public void updateMessage() {
            NumberFormat fmt = DecimalFormat.getInstance();
            fmt.setMinimumIntegerDigits(1);
            fmt.setMinimumFractionDigits(DoubleSliderEntry.this.precision);
            fmt.setMaximumFractionDigits(DoubleSliderEntry.this.precision);
            this.setMessage((Component)Component.literal((String)("Value: " + fmt.format(DoubleSliderEntry.this.value.get()))));
        }

        protected void applyValue() {
            double rounded = BigDecimal.valueOf(DoubleSliderEntry.this.minimum + (DoubleSliderEntry.this.maximum - DoubleSliderEntry.this.minimum) * this.value).setScale(DoubleSliderEntry.this.precision, RoundingMode.HALF_UP).doubleValue();
            DoubleSliderEntry.this.value.set(rounded);
        }

        public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
            return DoubleSliderEntry.this.isEditable() && super.keyPressed(keyCode, scanCode, modifiers);
        }

        public boolean mouseDragged(double mouseX, double mouseY, int button, double dragX, double dragY) {
            return DoubleSliderEntry.this.isEditable() && super.mouseDragged(mouseX, mouseY, button, dragX, dragY);
        }

        public void setValue(double value) {
            this.value = value;
        }
    }
}

