/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.equipment.armor;

import com.simibubi.create.content.equipment.armor.BacktankUtil;
import com.simibubi.create.content.equipment.armor.BaseArmorItem;
import com.simibubi.create.foundation.advancement.AllAdvancements;
import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponents;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.item.enchantment.ItemEnchantments;
import net.minecraft.world.level.Level;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.tick.EntityTickEvent;

@EventBusSubscriber
public class DivingHelmetItem
extends BaseArmorItem {
    public static final EquipmentSlot SLOT = EquipmentSlot.HEAD;
    public static final ArmorItem.Type TYPE = ArmorItem.Type.HELMET;

    public DivingHelmetItem(Holder<ArmorMaterial> material, Item.Properties properties, ResourceLocation textureLoc) {
        super(material, TYPE, properties, textureLoc);
    }

    public boolean supportsEnchantment(ItemStack stack, Holder<Enchantment> enchantment) {
        if (enchantment.is(Enchantments.AQUA_AFFINITY)) {
            return false;
        }
        return super.supportsEnchantment(stack, enchantment);
    }

    public int getEnchantmentLevel(ItemStack stack, Holder<Enchantment> enchantment) {
        if (enchantment.is(Enchantments.AQUA_AFFINITY)) {
            return 1;
        }
        return super.getEnchantmentLevel(stack, enchantment);
    }

    public ItemEnchantments getAllEnchantments(ItemStack stack, HolderLookup.RegistryLookup<Enchantment> lookup) {
        ItemEnchantments.Mutable enchants = new ItemEnchantments.Mutable(super.getAllEnchantments(stack, lookup));
        enchants.set((Holder)lookup.getOrThrow(Enchantments.AQUA_AFFINITY), 1);
        return enchants.toImmutable();
    }

    public static boolean isWornBy(Entity entity) {
        return !DivingHelmetItem.getWornItem(entity).isEmpty();
    }

    public static ItemStack getWornItem(Entity entity) {
        if (!(entity instanceof LivingEntity)) {
            return ItemStack.EMPTY;
        }
        LivingEntity livingEntity = (LivingEntity)entity;
        ItemStack stack = livingEntity.getItemBySlot(SLOT);
        if (!(stack.getItem() instanceof DivingHelmetItem)) {
            return ItemStack.EMPTY;
        }
        return stack;
    }

    @SubscribeEvent
    public static void breatheUnderwater(EntityTickEvent.Pre event) {
        ServerPlayer sp;
        ItemStack helmet;
        boolean drowning;
        Entity entity = event.getEntity();
        if (!(entity instanceof LivingEntity)) {
            return;
        }
        LivingEntity entity2 = (LivingEntity)entity;
        Level world = entity2.level();
        boolean second = world.getGameTime() % 20L == 0L;
        boolean bl = drowning = entity2.getAirSupply() == 0;
        if (world.isClientSide) {
            entity2.getPersistentData().remove("VisualBacktankAir");
        }
        if ((helmet = DivingHelmetItem.getWornItem((Entity)entity2)).isEmpty()) {
            return;
        }
        boolean lavaDiving = entity2.isInLava();
        if (!helmet.has(DataComponents.FIRE_RESISTANT) && lavaDiving) {
            return;
        }
        if (!entity2.canDrownInFluidType(entity2.getEyeInFluidType()) && !lavaDiving) {
            return;
        }
        if (entity2 instanceof Player && ((Player)entity2).isCreative()) {
            return;
        }
        List<ItemStack> backtanks = BacktankUtil.getAllWithAir(entity2);
        if (backtanks.isEmpty()) {
            return;
        }
        if (lavaDiving) {
            if (entity2 instanceof ServerPlayer) {
                sp = (ServerPlayer)entity2;
                AllAdvancements.DIVING_SUIT_LAVA.awardTo((Player)sp);
            }
            if (backtanks.stream().noneMatch(backtank -> backtank.has(DataComponents.FIRE_RESISTANT))) {
                return;
            }
        }
        if (drowning) {
            entity2.setAirSupply(10);
        }
        if (world.isClientSide) {
            entity2.getPersistentData().putInt("VisualBacktankAir", Math.round(backtanks.stream().map(BacktankUtil::getAir).reduce(0, Integer::sum).intValue()));
        }
        if (!second) {
            return;
        }
        BacktankUtil.consumeAir(entity2, backtanks.get(0), 1);
        if (lavaDiving) {
            return;
        }
        if (entity2 instanceof ServerPlayer) {
            sp = (ServerPlayer)entity2;
            AllAdvancements.DIVING_SUIT.awardTo((Player)sp);
        }
        entity2.setAirSupply(Math.min(entity2.getMaxAirSupply(), entity2.getAirSupply() + 10));
        entity2.addEffect(new MobEffectInstance(MobEffects.WATER_BREATHING, 30, 0, true, false, true));
    }
}

