/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.trains.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.simibubi.create.content.contraptions.render.ContraptionVisual;
import com.simibubi.create.content.trains.bogey.BogeyVisual;
import com.simibubi.create.content.trains.entity.Carriage;
import com.simibubi.create.content.trains.entity.CarriageBogey;
import com.simibubi.create.content.trains.entity.CarriageContraptionEntity;
import com.simibubi.create.content.trains.entity.CarriageContraptionEntityRenderer;
import dev.engine_room.flywheel.api.visual.DynamicVisual;
import dev.engine_room.flywheel.api.visualization.VisualizationContext;
import dev.engine_room.flywheel.lib.transform.TransformStack;
import dev.engine_room.flywheel.lib.util.RecyclingPoseStack;
import net.createmod.catnip.data.Couple;
import net.createmod.catnip.data.Iterate;
import net.minecraft.nbt.CompoundTag;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class CarriageContraptionVisual
extends ContraptionVisual<CarriageContraptionEntity> {
    private final PoseStack poseStack = new RecyclingPoseStack();
    @Nullable
    private @Nullable Couple<@Nullable VisualizedBogey> bogeys;
    private Couple<Boolean> bogeyHidden = Couple.create(() -> false);

    public CarriageContraptionVisual(VisualizationContext context, CarriageContraptionEntity entity, float partialTick) {
        super(context, entity, partialTick);
        entity.bindInstance(this);
        this.animate(partialTick);
    }

    public void setBogeyVisibility(boolean first, boolean visible) {
        this.bogeyHidden.set(first, (Object)(!visible ? 1 : 0));
    }

    @Override
    public void beginFrame(DynamicVisual.Context ctx) {
        super.beginFrame(ctx);
        this.animate(ctx.partialTick());
    }

    private boolean checkCarriage(float pt) {
        if (this.bogeys != null) {
            return true;
        }
        Carriage carriage = ((CarriageContraptionEntity)this.entity).getCarriage();
        if (((CarriageContraptionEntity)this.entity).validForRender && carriage != null) {
            this.bogeys = carriage.bogeys.mapNotNull(bogey -> VisualizedBogey.of(this.visualizationContext, bogey, pt));
            this.updateLight(pt);
            return true;
        }
        return false;
    }

    private void animate(float partialTick) {
        if (!this.checkCarriage(partialTick)) {
            return;
        }
        float viewYRot = ((CarriageContraptionEntity)this.entity).getViewYRot(partialTick);
        float viewXRot = ((CarriageContraptionEntity)this.entity).getViewXRot(partialTick);
        int bogeySpacing = ((CarriageContraptionEntity)this.entity).getCarriage().bogeySpacing;
        this.poseStack.pushPose();
        Vector3f visualPosition = this.getVisualPosition(partialTick);
        TransformStack.of((PoseStack)this.poseStack).translate((Vector3fc)visualPosition);
        for (boolean current : Iterate.trueAndFalse) {
            VisualizedBogey visualizedBogey = (VisualizedBogey)this.bogeys.get(current);
            if (visualizedBogey == null) continue;
            if (((Boolean)this.bogeyHidden.get(current)).booleanValue()) {
                visualizedBogey.visual.hide();
                continue;
            }
            this.poseStack.pushPose();
            CarriageBogey bogey = visualizedBogey.bogey;
            CarriageContraptionEntityRenderer.translateBogey(this.poseStack, bogey, bogeySpacing, viewYRot, viewXRot, partialTick);
            this.poseStack.translate(0.0, -1.5078125, 0.0);
            CompoundTag bogeyData = bogey.bogeyData;
            if (bogeyData == null) {
                bogeyData = new CompoundTag();
            }
            visualizedBogey.visual.update(bogeyData, bogey.wheelAngle.getValue(partialTick), this.poseStack);
            this.poseStack.popPose();
        }
        this.poseStack.popPose();
    }

    @Override
    public void updateLight(float partialTick) {
        super.updateLight(partialTick);
        if (this.bogeys == null) {
            return;
        }
        this.bogeys.forEach(bogey -> {
            if (bogey != null) {
                int packedLight = CarriageContraptionEntityRenderer.getBogeyLightCoords((CarriageContraptionEntity)this.entity, bogey.bogey, partialTick);
                bogey.visual.updateLight(packedLight);
            }
        });
    }

    @Override
    public void _delete() {
        super._delete();
        if (this.bogeys == null) {
            return;
        }
        this.bogeys.forEach(bogey -> {
            if (bogey != null) {
                bogey.visual.delete();
            }
        });
    }

    private record VisualizedBogey(CarriageBogey bogey, BogeyVisual visual) {
        @Nullable
        static VisualizedBogey of(VisualizationContext ctx, CarriageBogey bogey, float partialTick) {
            BogeyVisual visual = bogey.getStyle().createVisual(bogey.getSize(), ctx, partialTick, true);
            if (visual == null) {
                return null;
            }
            return new VisualizedBogey(bogey, visual);
        }
    }
}

