/*
 * Decompiled with CFR 0.152.
 */
package xaero.map.gui;

import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import xaero.map.WorldMapSession;
import xaero.map.gui.MySmallButton;
import xaero.map.gui.ScreenBase;
import xaero.map.world.MapWorld;

public class GuiPlayerTpCommand
extends ScreenBase {
    private MySmallButton confirmButton;
    private EditBox commandFormatTextField;
    private String commandFormat;

    public GuiPlayerTpCommand(Screen parent, Screen escape) {
        super(parent, escape, (Component)Component.translatable((String)"gui.xaero_wm_player_teleport_command"));
    }

    @Override
    public void init() {
        super.init();
        WorldMapSession session = WorldMapSession.getCurrentSession();
        MapWorld mapWorld = session.getMapProcessor().getMapWorld();
        if (this.commandFormat == null) {
            this.commandFormat = mapWorld.getPlayerTeleportCommandFormat();
        }
        this.commandFormatTextField = new EditBox(this.font, this.width / 2 - 100, this.height / 7 + 50, 200, 20, (Component)Component.translatable((String)"gui.xaero_wm_player_teleport_command"));
        this.commandFormatTextField.setValue(this.commandFormat);
        this.commandFormatTextField.setMaxLength(128);
        this.addWidget(this.commandFormatTextField);
        this.confirmButton = new MySmallButton(this.width / 2 - 155, this.height / 6 + 168, (Component)Component.translatable((String)"gui.xaero_confirm", (Object[])new Object[0]), b -> {
            mapWorld.setPlayerTeleportCommandFormat(this.commandFormat);
            mapWorld.saveConfig();
            this.goBack();
        });
        this.addRenderableWidget((GuiEventListener)this.confirmButton);
        this.addRenderableWidget((GuiEventListener)new MySmallButton(this.width / 2 + 5, this.height / 6 + 168, (Component)Component.translatable((String)"gui.xaero_cancel", (Object[])new Object[0]), b -> this.goBack()));
    }

    public void renderBackground(GuiGraphics guiGraphics, int i, int j, float f) {
        super.renderBackground(guiGraphics, i, j, f);
        guiGraphics.drawCenteredString(this.font, this.title, this.width / 2, 20, 0xFFFFFF);
        guiGraphics.drawCenteredString(this.font, "{x} {y} {z} {name}", this.width / 2, this.height / 7 + 36, -5592406);
    }

    @Override
    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partial) {
        this.renderEscapeScreen(guiGraphics, mouseX, mouseY, partial);
        super.render(guiGraphics, mouseX, mouseY, partial);
        this.commandFormatTextField.render(guiGraphics, mouseX, mouseY, partial);
    }

    public void tick() {
        this.commandFormat = this.commandFormatTextField.getValue();
        this.confirmButton.active = this.commandFormat != null && this.commandFormat.length() > 0;
    }

    public boolean keyPressed(int par1, int par2, int par3) {
        if (par1 == 257 && this.commandFormat != null && this.commandFormat.length() > 0) {
            this.confirmButton.onClick(0.0, 0.0);
        }
        return super.keyPressed(par1, par2, par3);
    }
}

